clear all
close all
clc
move=0.2;
power=3;
rho_min=0.001;
frac_s=.3;
frac_l=.3;
rad=1.5;
oc_exp=.5;
% Read the input from a file; change the file name acc 2 no of elements
fid = fopen('elem400.dat','r');
fgets(fid);
fgets(fid);
Nelem = fscanf(fid,'%i\n',1);
fgets(fid);
fgets(fid);
elemdata = fscanf(fid,'%i\n',[6,Nelem]);
elemdata = elemdata';
% Material property data
fgets(fid);
fgets(fid);
NmaterialID = 1;
for i = 1:Nelem
    if(NmaterialID < elemdata(i,2))
        NmaterialID = elemdata(i,2);
    end
end
matprop = fscanf(fid,'%g\n',[4,NmaterialID]);
matprop = matprop';
% Nodal coordinates
fgets(fid);
Nnode = fscanf(fid,'%i\n',1);
fgets(fid);
fgets(fid);
nodedata = fscanf(fid,'%i %g %g\n',[3, Nnode]);
nodedata = nodedata';
% Displacement boundary conditions
fgets(fid);
Ndispbc = fscanf(fid,'%i\n',1);
fgets(fid);
dispbc = fscanf(fid,'%i %g %g\n',[3, Ndispbc]);
dispbc = dispbc';
% Force boundary conditions
fgets(fid);
Nforcebc = fscanf(fid,'%i\n',1);
fgets(fid);
forcebc = fscanf(fid,'%i %g %g\n',[3, Nforcebc]);
forcebc = forcebc';
fclose(fid);
nely=length(unique(nodedata(:,3)))-1;
nelx=length(unique(nodedata(:,2)))-1;
Vi_bar=(max(nodedata(:,2))-min(nodedata(:,2)))*(max(nodedata(:,3))-min(nodedata(:,3)))*matprop(1,4)/size(elemdata,1);
%Vstar=frac*Vi_bar;
rho=frac_s*ones(size(elemdata,1),1);
calc_Bdet(elemdata,nodedata);
change=1;
loop=0;
%define filter for sensitivity
midpoint=[mean(reshape(nodedata(elemdata(:,3:6)',2),4,Nelem),1)' mean(reshape(nodedata(elemdata(:,3:6)',3),4,Nelem),1)'];
dist=zeros(Nelem,Nelem);
wgt=zeros(Nelem,Nelem);
for i=1:Nelem
    dist(i,:)=sqrt((midpoint(i,1)-midpoint(:,1)').^2+(midpoint(i,2)-midpoint(:,2)').^2);
    wgt(i,:)=(rad-dist(i,:)).*le(dist(i,:),rad);
    wgt(i,:)=wgt(i,:)/sum(wgt(i,:));
end
wgt=sparse(wgt);
while(change>0.01)
    [c,dc]=Fem2D_stiffness(matprop,nodedata,elemdata,rho,power,forcebc,dispbc);
    dc_new=(wgt*(rho.*dc))./rho;
    loop=loop+1;
    l1=0;l2=1e5;
    while (l2-l1)/(l2+l1)>.001
        lmid=.5*(l2+l1);
        rho_new=max(rho_min,max(rho-move,min(1,min(rho+move,rho.*(dc_new/Vi_bar/lmid).^oc_exp))));
 %       rho_new=max(rho_min,min(1,rho.*(dc_new/Vi_bar/lmid).^oc_exp));       
 if sum(rho_new)>frac_s*Nelem, l1=lmid;else l2=lmid; end
    end
    change=max(abs(rho_new-rho));
    rho=rho_new;
    fprintf('Iter:%2i Obj:%5.4f Vol:%4.3f ch:%4.3f\n',loop,c,mean(rho),change);
    print_rho=reshape(rho,nely,nelx);
    colormap(gray);imagesc(1-print_rho);caxis([0 1]);axis equal; axis off;drawnow;
end